/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import java.awt.image.BufferedImage;
import java.util.logging.Level;
import javax.print.attribute.standard.OrientationRequested;
import jzebra.LogIt;

public class PaperFormat {
    private static final int REVERSE_PORTRAIT = 9238;
    private float width = 8.5f;
    private float height = 11.0f;
    private Float autoWidth;
    private Float autoHeight;
    private boolean autoSize;
    private int orientation = 1;
    private int units = 25400;

    public PaperFormat() {
    }

    public PaperFormat(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public PaperFormat(float width, float height, int units) {
        this.units = units;
        this.width = width;
        this.height = height;
    }

    public void setAutoSize(BufferedImage b) {
        if (b != null) {
            PaperFormat.setAutoSize(b.getWidth(), b.getHeight(), this);
            this.autoSize = true;
        } else {
            LogIt.log(Level.WARNING, "Image specified is empty.");
        }
    }

    public static int parseOrientation(String orientation) {
        if (orientation.equalsIgnoreCase("landscape")) {
            return 0;
        }
        if (orientation.equalsIgnoreCase("portrait")) {
            return 1;
        }
        if (orientation.equalsIgnoreCase("reverse-landscape") || orientation.equalsIgnoreCase("reverse_landscape") || orientation.equalsIgnoreCase("reverse landscape")) {
            return 2;
        }
        if (orientation.equalsIgnoreCase("reverse-portrait") || orientation.equalsIgnoreCase("reverse_portrait") || orientation.equalsIgnoreCase("reverse portrait")) {
            return 9238;
        }
        LogIt.log(Level.WARNING, "Orientation specified \"" + orientation + "\" not recognized.");
        return -1;
    }

    public String getOrientationDescription() {
        return PaperFormat.getOrientationDescription(this.orientation);
    }

    public static String getOrientationDescription(int orientation) {
        switch (orientation) {
            case 9238: {
                return "reverse-portrait";
            }
            case 0: {
                return "landscape";
            }
            case 2: {
                return "reverse-landscape";
            }
            case 1: {
                return "portrait";
            }
        }
        return "unknown";
    }

    public void setOrientation(String s) {
        this.orientation = PaperFormat.parseOrientation(s);
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        if (this.orientation == 9238) {
            return 1;
        }
        return this.orientation;
    }

    public OrientationRequested getOrientationRequested() {
        switch (this.orientation) {
            case 0: {
                return OrientationRequested.LANDSCAPE;
            }
            case 2: {
                return OrientationRequested.REVERSE_LANDSCAPE;
            }
            case 9238: {
                return OrientationRequested.REVERSE_PORTRAIT;
            }
        }
        return OrientationRequested.PORTRAIT;
    }

    public static void setAutoSize(int imageWidth, int imageHeight, PaperFormat p) {
        if (p.isLandscape()) {
            int temp = imageWidth;
            imageWidth = imageHeight;
            imageHeight = temp;
        }
        float imageRatio = (float)imageWidth / (float)imageHeight;
        float paperRatio = p.getWidth() / p.getHeight();
        float wRatio = (float)imageWidth / p.getWidth();
        float hRatio = (float)imageHeight / p.getHeight();
        if (imageRatio >= paperRatio) {
            p.setAutoWidth(p.getWidth());
            p.setAutoHeight((float)imageHeight / wRatio);
        } else {
            p.setAutoHeight(p.getHeight());
            p.setAutoWidth((float)imageWidth / hRatio);
        }
        p.setAutoSize(true);
    }

    public boolean isPortrait() {
        return this.getOrientation() == 9238 || this.getOrientation() == 1;
    }

    public boolean isLandscape() {
        return this.getOrientation() == 0 || this.getOrientation() == 2;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public String toString() {
        return "Size: " + this.width + this.getUnitDescription() + " x " + this.height + this.getUnitDescription() + ", AutoSize: " + this.getAutoWidth() + this.getUnitDescription() + " x " + this.getAutoHeight() + this.getUnitDescription() + " (orientation is \"" + this.getOrientationDescription() + "\", auto size is " + (this.autoSize ? "enabled)" : "disabled)");
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public final void setAutoWidth(float width) {
        this.autoWidth = Float.valueOf(width);
    }

    public final void setAutoHeight(float height) {
        this.autoHeight = Float.valueOf(height);
    }

    public final float getAutoWidth() {
        return this.autoWidth == null || !this.autoSize ? this.width : this.autoWidth.floatValue();
    }

    public final float getAutoHeight() {
        return this.autoHeight == null || !this.autoSize ? this.height : this.autoHeight.floatValue();
    }

    public final void setUnits(int units) {
        this.units = units;
    }

    public String getUnitDescription() {
        switch (this.units) {
            case 25400: {
                return "in";
            }
            case 1000: {
                return "mm";
            }
        }
        return null;
    }

    public int getUnits() {
        return this.units;
    }

    public static PaperFormat parseSize(String width, String height) throws NumberFormatException {
        if (width.toLowerCase().endsWith("in") && height.toLowerCase().endsWith("in")) {
            return PaperFormat.parseSize(width.split("in")[0], height.split("in")[0], "in");
        }
        if (width.toLowerCase().endsWith("mm") && height.toLowerCase().endsWith("mm")) {
            return PaperFormat.parseSize(width.split("mm")[0], height.split("mm")[0], "mm");
        }
        return PaperFormat.parseSize(width, height, null);
    }

    public static PaperFormat parseSize(String width, String height, String units) throws NumberFormatException {
        if (width == null || height == null) {
            throw new NumberFormatException("Cannot parse float from null value");
        }
        Float w = Float.valueOf(Float.parseFloat(width.trim()));
        Float h = Float.valueOf(Float.parseFloat(height.trim()));
        int unitz = PaperFormat.parseUnits(units);
        if (unitz != -1) {
            return new PaperFormat(w.floatValue(), h.floatValue(), unitz);
        }
        return new PaperFormat(w.floatValue(), h.floatValue());
    }

    public static int parseUnits(String units) {
        if (units == null) {
            return -1;
        }
        if (units.equalsIgnoreCase("in") || units.equalsIgnoreCase("inch") || units.equalsIgnoreCase("standard")) {
            return 25400;
        }
        if (units.equalsIgnoreCase("mm") || units.equalsIgnoreCase("metric")) {
            return 1000;
        }
        return -1;
    }
}

