<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: RoleRightModel.php,v 1.1.2.3 2024/11/15 13:21:48 dgoron Exp $

namespace Pmb\Users\Models;

use Pmb\Common\Models\Model;

class RoleRightModel extends Model
{
    protected $ormName = "Pmb\Users\Orm\RoleRightOrm";
    
    public function setPropertiesFromForm(object $data)
    {
        $this->visible = $data->visible;
        $this->privilege = $data->privilege;
        $this->log = $data->log;
    }
    
    public function save()
    {
        if (!$this->id) {
            $ormClass = $this->ormName;
            $instances = $ormClass::finds([
                'num_role' => $this->numRole,
                'component' => $this->component,
                'module' => $this->module,
                'categ' => $this->categ,
                'sub' => $this->sub,
                'url_extra' => $this->urlExtra,
            ]);
            if (!empty($instances[0])) {
                $this->id = $instances[0]->id;
            }
        }
        $orm = new $this->ormName($this->id);
        $orm->component = $this->component;
        $orm->module = $this->module;
        $orm->categ = $this->categ;
        $orm->sub = $this->sub;
        $orm->url_extra = $this->urlExtra;
        $orm->action = $this->action;
        $orm->visible = $this->visible;
        $orm->privilege = $this->privilege;
        $orm->log = $this->log;
        $orm->num_role = $this->numRole;
        
        $orm->save();
        if(!$this->id) {
            $this->id = $orm->id;
        }
        return $orm;
    }
    
    public function delete()
    {
        $orm = new $this->ormName($this->id);
        $orm->delete();
    }
}
